<?php

namespace Demo\Portal\Pub\Controller;

class Portal extends \XF\Pub\Controller\AbstractController
{
	public function actionIndex()
	{
		$page = $this->filterPage();
		$perPage = $this->options()->demoPortalFeaturedPerPage;

		/** @var \Demo\Portal\Repository\FeaturedThread $repo */
		$repo = $this->repository('Demo\Portal:FeaturedThread');

		$finder = $repo->findFeaturedThreadsForPortalView()
			->limit($perPage * 3);

		$featuredThreads = $finder->fetch()
			->filter(function(\Demo\Portal\Entity\FeaturedThread $featuredThread)
			{
				return ($featuredThread->Thread->canView());
			})
			->sliceToPage($page, $perPage);

		$threads = $featuredThreads->pluckNamed('Thread');
		$posts = $threads->pluckNamed('FirstPost', 'first_post_id');

		/** @var \XF\Repository\Attachment $attachRepo */
		$attachRepo = $this->repository('XF:Attachment');
		$attachRepo->addAttachmentsToContent($posts, 'post');

		$viewParams = [
			'featuredThreads' => $featuredThreads,
			'total' => $finder->total(),
			'page' => $page,
			'perPage' => $perPage
		];
		return $this->view('Demo\Portal:View', 'demo_portal_view', $viewParams);
	}
}