<?php

namespace Demo\Portal;

use XF\Db\Schema\Alter;
use XF\Db\Schema\Create;

class Setup extends \XF\AddOn\AbstractSetup
{
	use \XF\AddOn\StepRunnerInstallTrait;
	use \XF\AddOn\StepRunnerUpgradeTrait;
	use \XF\AddOn\StepRunnerUninstallTrait;

	public function installStep1()
	{
		$this->schemaManager()->alterTable('xf_forum', function(Alter $table)
		{
			$table->addColumn('demo_portal_auto_feature', 'tinyint')->setDefault(0);
		});
	}

	public function installStep2()
	{
		$this->schemaManager()->alterTable('xf_thread', function(Alter $table)
		{
			$table->addColumn('demo_portal_featured', 'tinyint')->setDefault(0);
		});
	}

	public function installStep3()
	{
		$this->schemaManager()->createTable('xf_demo_portal_featured_thread', function(Create $table)
		{
			$table->addColumn('thread_id', 'int');
			$table->addColumn('featured_date', 'int');
			$table->addPrimaryKey('thread_id');
		});
	}
	
	public function installStep4()
	{
		$this->createWidget('demo_portal_view_members_online', 'members_online', [
			'positions' => ['demo_portal_view_sidebar' => 10]
		]);

		$this->createWidget('demo_portal_view_new_posts', 'new_posts', [
			'positions' => ['demo_portal_view_sidebar' => 20]
		]);

		$this->createWidget('demo_portal_view_new_profile_posts', 'new_profile_posts', [
			'positions' => ['demo_portal_view_sidebar' => 30]
		]);

		$this->createWidget('demo_portal_view_forum_statistics', 'forum_statistics', [
			'positions' => ['demo_portal_view_sidebar' => 40]
		]);

		$this->createWidget('demo_portal_view_share_page', 'share_page', [
			'positions' => ['demo_portal_view_sidebar' => 50]
		]);
	}

	public function uninstallStep1()
	{
		$this->schemaManager()->alterTable('xf_forum', function(Alter $table)
		{
			$table->dropColumns('demo_portal_auto_feature');
		});
	}

	public function uninstallStep2()
	{
		$this->schemaManager()->alterTable('xf_thread', function(Alter $table)
		{
			$table->dropColumns('demo_portal_featured');
		});
	}

	public function uninstallStep3()
	{
		$this->schemaManager()->dropTable('xf_demo_portal_featured_thread');
	}
}