<?php

namespace Demo\Portal\XF\Pub\Controller;

class Forum extends XFCP_Forum
{
	public function setupThreadCreate(\XF\Entity\Forum $forum)
	{
		/** @var \Demo\Portal\XF\Service\Thread\Creator $creator */
		$creator = parent::setupThreadCreate($forum);

		if ($forum->demo_portal_auto_feature)
		{
			$creator->setFeatureThread(true);
		}
		else
		{
			$setOptions = $this->filter('_xfSet', 'array-bool');
			if ($setOptions)
			{
				$thread = $creator->getThread();

				if ($thread->canFeatureUnfeature() && isset($setOptions['featured']))
				{
					$creator->setFeatureThread($this->filter('featured', 'bool'));
				}
			}
		}

		return $creator;
	}
}